package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.ReminderScheduleTypeDTO;
import gov.va.med.mhv.calendar.model.ReminderScheduleType;

import org.springframework.core.convert.converter.Converter;

public class ReminderScheduleTypeConverter implements Converter<ReminderScheduleType, ReminderScheduleTypeDTO> {

	@Override
	public ReminderScheduleTypeDTO convert(ReminderScheduleType source) {
		ReminderScheduleTypeDTO target = new ReminderScheduleTypeDTO();
		
		target.setId(source.getId());
		target.setReminderType(source.getReminderType());
		target.setReminderOffsetMask(source.getReminderOffsetMask());
		
		return target;
	}
	
	public ReminderScheduleType convert(ReminderScheduleTypeDTO source) {
		ReminderScheduleType target = new ReminderScheduleType();

		target.setId(source.getId());
		target.setReminderType(source.getReminderType());
		target.setReminderOffsetMask(source.getReminderOffsetMask());
		
		return target;
	}
	
	public List<ReminderScheduleTypeDTO> convert(List<ReminderScheduleType> source) {
		List <ReminderScheduleTypeDTO> reminderScheduleTypeDto= null;
		if(null !=source) {
			reminderScheduleTypeDto = new ArrayList<ReminderScheduleTypeDTO>();

			for (ReminderScheduleType reminderScheduleType: source) {
				reminderScheduleTypeDto.add(this.convert(reminderScheduleType));
			}

		}

		return reminderScheduleTypeDto;
	}

}
